C      *****************************************************************
C      * Subroutine OutResults                                         *
C      * Outputs species concentration and known total information to  *
C      * the screen and to the output file.                            *
C      *                                                               *
C      * Variables:                                                    *
C      * Comment   -Input - The description of the input file.         *
C      *                    Unitless.                                  *
C      *                    (Common block VModel, file VModel.f)       *
C      * FmtLab    -Local - Format descriptions for text output        *
C      *                    statements.  Unitless.                     *
C      * FmtNum    -Local - Format descriptions for data output        *
C      *                    statements.  Unitless.                     *
C      * FrsTim    -Input - A flag that is a 1 the first time the soil *
C      *                    model is called and is a 0 otherwise.      *
C      *                    Input from TREGRO, or read into the model  *
C      *                    by the routine InParam.  Unitless.         *
C      *                    (Common block VModel, file VModel.f)       *
C      * I         -Local - Array index.  Unitless.                    *
C      * J         -Local - Array index.  Unitless.                    *
C      * KT        -Input - A matrix, of size NComp by NLayer, of the  *
C      *                    known total amount for each component, for *
C      *                    each layer.  The total includes the amount *
C      *                    of the component as a free component and as*
C      *                    part of all dependent species.  Units are  *
C      *                    mol.                                       *
C      *                    (Common block VModel, file VModel.f)       *
C      * Labels    -Input - A vector, of size NSpecies, of the name for*
C      *                    each species.  Unitless.                   *
C      *                    (Common block VModel, file VModel.f)       *
C      * NComp     -Input - The number of components in the system.    *
C      *                    Unitless.                                  *
C      *                    (Common block VModel, file VModel.f)       *
C      * NPhases   -Input - The number of phases in the system.        *
C      *                    Unitless.                                  *
C      *                    (Common block VSolidPhase, file VModel.f)  *
C      * NSpecies  -Input - The number of species in the system (i.e.  *
C      *                    the number of components plus the number   *
C      *                    of dependent species).  Unitless.          *
C      *                    (Common block VModel, file VModel.f)       *
C      * PMass     -Input - A matrix, of size NPhases by NLayers, of   *
C      *                    the amount of each phase dissolved or      *
C      *                    precipitated, per layer.  Units are mol.   *
C      *                    (Common block VSolidPhase, file VModel.f)  *
C      * RunNumber -Input - The number of the run that was just        *
C      *                    completed.  Unitless.                      *
C      * SpConc    -Input - A matrix, of size NSpecies by NLayers, of  *
C      *                    species concentrations, one set for each   *
C      *                    layer. Units are mol/L.                    *
C      *                    (Common block VModel, file VModel.f)       *
C      * StndAlone -Input - Indicates whether soil model is running as *
C      *                    a stand alone model (TRUE) or not (FALSE). * 
C      *                    Unitless.                                  *
C      *                    (Common block VModel, file VModel.f)       *
C      * Tab       -Local - The tab character.  Unitless.              *
C      * TotRuns   -Input - The total number of times the model will be*
C      *                    run.  Unitless.                            *
C      *****************************************************************
       SUBROUTINE OUTRESULTS(UNITNUM,RUNNUMBER, TOTRUNS)
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							INTEGER I, J, RUNNUMBER, TOTRUNS, UNITNUM
							CHARACTER*1 TAB
							CHARACTER*60 FMTLAB(2), FMTNUM(2)

C      *----------------------*
C      * Initialize constants *
C      *----------------------*
   	   TAB = CHAR(9)
							FMTLAB(1)  = '(A10, A1, A10, 100(A1, A2, A12))'
							FMTLAB(2)  = '(A10, 100(A1, A2, A12))'
							FMTNUM(1)  = '(I3, A1, I3, 100(A1,E12.5))'
	    		FMTNUM(2)  = '(I3, 100(A1,E12.5))'

C      *-----------------------------------------------------*
C      * If this is the first time the soil model is called, *
C      * write out headings for file.                        *
C      *-----------------------------------------------------*
       IF (FRSTIM.EQ.1) THEN
          WRITE(UNITNUM,*) 
	         WRITE(UNITNUM,*) TAB, 'THE SPECIES CONCENTRATIONS (C.) ',
     >    '(mol/L), THE KTs (T.) (mol) AND THE PHASE ',
     >    'MASS (M.) (mol)'
          IF (STNDALONE) THEN
	            WRITE(UNITNUM,FMTLAB(1)) 'RUN NUMBER', TAB
     >       ' LAYER', ((TAB,('C.',LABELS(I)),I=1,NSPECIES),
     >       (TAB,('T.',LABELS(I)),I=1,NCOMP),
     >       (TAB,('M.',PHASENAMES(I)),I=1,NPHASES))

             WRITE(6,*) 
             WRITE(6,*) 'File description:'
             WRITE(6,*) COMMENT
             WRITE(6,*) 'Run number 1 complete...'
             WRITE(6,*) 'Working...'
          ELSE
	            WRITE(UNITNUM,FMTLAB(2)) 
     >       ' LAYER', ((TAB,('C.',LABELS(I)),I=1,NSPECIES),
     >       (TAB,('T.',LABELS(I)),I=1,NCOMP),
     >       (TAB,('M.',PHASENAMES(I)),I=1,NPHASES))
          ENDIF

	      ENDIF

C      *------------------------------------------*
C      * Output species concentration to file and *
C      * species concentration and KT to screen.  *
C      *------------------------------------------*
       DO 300 J=1, NLAYERS
          IF (STNDALONE) THEN
 	           WRITE(UNITNUM,FMTNUM(1)) 
     >        RUNNUMBER, TAB, J, ((TAB,SPCONC(I,J),I=1,NSPECIES),
     >        (TAB,KT(I,J),I=1,NCOMP),
     >        (TAB,PMASS(I,J),I=1,NPHASES))
           ELSE
 	           WRITE(UNITNUM,FMTNUM(2)) 
     >        J, ((TAB,SPCONC(I,J),I=1,NSPECIES),
     >        (TAB,KT(I,J),I=1,NCOMP),
     >        (TAB,PMASS(I,J),I=1,NPHASES))
          ENDIF
  300  CONTINUE
        
       IF (STNDALONE) THEN
          IF (MOD(RUNNUMBER,50).EQ.0) THEN
             WRITE(6,399) 'Runs numbered ',RUNNUMBER-49, 
     >       ' to ',RUNNUMBER, ' out of ', TOTRUNS, ' complete...'
  399        FORMAT(' ',A14,I4,A4,I4,A8, I4, A12)
             WRITE(6,*) 'Working...'
          ELSE IF (RUNNUMBER.EQ.TOTRUNS) THEN
                WRITE(6,402) 'All runs up to run number ', 
     >          TOTRUNS, ' complete...'
  402        FORMAT(' ',A27,I4,A12)
          ENDIF
       ENDIF

       RETURN
       END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
